% Definizione parametri HF model

run('F16data.m')

%% parametri simulazione

simulation.TiBr      = 2.0;             % [s]           durata simulazione
simulation.DT        = 1e-4;            % [s]           passo di integrazione
simulation.initPos   = F16.x0(5);       % [rad]         posizione iniziale (albero lento)

simulation.tauFilter = 5*10e-5;         % [s]           tempo caratteristico filtro I_3eq

simulation.timeCom   = [0 0.1 0.1+simulation.DT simulation.TiBr];   % parametri comando 'Com'
simulation.com       = [0 0 0.1 0.1];

%% controller

controller.Gprop    = 1e5;              % [1/s]         guadagno proporzionale controller     % 5e2/tau
controller.W_refMax = 8000*pi/30;       % [rad/s]       saturazione errore posizione          % 6060*pi/30%;
controller.I_Max    = 22.5;             % [A]           saturazione I_ref
controller.Knoise   = 0;                % []            coefficiente moltiplicativo Rumore (0 - 1 - 10 - 100)

controller.PID.GAP  = 0.05;             % [Nms/rad]     guadagno proporzionale PID            % 0.05;%0.1;%0.75
controller.PID.GAI  = 0;                % [Nm/rad]      guadagno integrativo PID              % 10
controller.PID.GAD  = 0;                % [Nms/rad]     guadagno derivativo PID               % 5e-5
controller.PID.ErIM = 100;              % [Nm]          Max Errore Integrativo

%% inverter

inverter.PWM.hb           = 0.5;        % [A]           ampiezza banda di isteresi
inverter.Hbridge.Vdc      = 48;         % [V]           tensione alimentazione
inverter.Hbridge.RSnubber = 1e5;        % [ohm]         resistenza snubber
inverter.Hbridge.CSnubber = inf;        % [F]           capacit snubber
inverter.Hbridge.Ron      = 1e-2;       % [ohm]         Ron (in Universal Bridge)

%% motore

BLDC.P    = 2;                          % []            numero paia poli
BLDC.Nabc = [1 1 1];                    % []            frazione spire attive (fasi A, B, C)

BLDC.Rs   = 2.130;                      % [ohm]         resistenza nominale fase-fase (es. Rab)
BLDC.Ls   = 720*1e-6;                   % [H]           induttanza nominale fase-fase (es. Lab)
BLDC.Ke   = 0.0752/2;                   % [Nm/A]        costante di fcem del motore  

BLDC.TMM = 1.689;                      % [Nm]          saturazione coppia

BLDC.zeta = 0;                          % []            modulo eccentricit statica
BLDC.phi  = 0;                          % []            fase eccentricit statica

%% dinamica motore-trasmissione

dynamics.tau = 1/500;                   % rapporto di trasmissione

dynamics.JM            = 130e-007;      % [kg*m^2]      Momento d'inerzia del DC Motor (AV=albero veloce)
dynamics.CM            = 30/pi*1e-6;    % [N*m*s/rad]   Coefficiente di smorzamento viscoso dimensionale DC Motor (AV)
dynamics.JU            = 12e-6;         % [kg*m^2]      Momento d'inerzia utilizzatore ridotto all'albero veloce
dynamics.CU            = 4.5070e-7;     % [N*m*s/rad]   Coefficiente di smorzamento viscoso dimensionale utilizz.(AV)

dynamics.friction.FSTm = 0.06;          % []            attrito statico  motore       (albero veloce - espresso in percentuale di BLDC.TMM)
dynamics.friction.FDTm = 0.03;          % []            attrito dinamico motore       (albero veloce - espresso in percentuale di BLDC.TMM)
dynamics.friction.FSTu = 0.04;          % []            attrito statico  utilizzatore (albero veloce - espresso in percentuale di BLDC.TMM)
dynamics.friction.FDTu = 0.02;          % []            attrito dinamico utilizzatore (albero veloce - espresso in percentuale di BLDC.TMM)

dynamics.BLK           = 1e-5;          % [rad]         Backlash Width (albero lento)

dynamics.ThUmin        = -1;            % [rad]         finecorsa inferiore
dynamics.ThUmax        = 1;             % [rad]         finecorsa superiore
























